/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BootstrapSettings;
import de.willuhn.jameica.system.PlatformMacOS;
import de.willuhn.jameica.system.WorkdirChooser;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.io.IOException;

public class Platform {
    public static final int OS_UNKNOWN = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_WINDOWS = 2;
    public static final int OS_MAC = 3;
    public static final int OS_LINUX_64 = 4;
    public static final int OS_WINDOWS_64 = 5;
    public static final int OS_FREEBSD = 6;
    public static final int OS_FREEBSD_64 = 7;
    protected File workdir = null;
    private int os = -1;

    public static Platform getInstance() {
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().startsWith("mac os")) {
            return new PlatformMacOS();
        }
        return new Platform();
    }

    public static boolean inProgramDir(File f) throws IOException {
        String program;
        if (f == null) {
            return false;
        }
        String test = f.getCanonicalPath();
        return test.startsWith((program = new File(".").getCanonicalPath()) + File.separator) || test.equals(program);
    }

    public File getWorkdir() throws Exception {
        if (this.workdir != null) {
            return this.workdir;
        }
        try {
            String dir = null;
            if (dir == null || dir.length() == 0) {
                dir = Application.getStartupParams().getWorkDir();
            }
            if (!(Application.inServerMode() || dir != null && dir.length() != 0)) {
                dir = new WorkdirChooser().getWorkDir();
            }
            if (dir == null || dir.length() == 0) {
                dir = this.getDefaultWorkdir();
            }
            this.workdir = new File(dir).getCanonicalFile();
            File home = new File(System.getProperty("user.home")).getCanonicalFile();
            if (home != null && home.equals(this.workdir)) {
                this.workdir = new File(this.getDefaultWorkdir()).getCanonicalFile();
                Logger.error((String)("not allowed to choose the users home dir (" + home + ") - auto-fixing to " + this.workdir));
            }
            if (this.workdir.exists() && !this.workdir.isDirectory()) {
                throw new ApplicationException("Benutzerordner " + this.workdir + " kann nicht erstellt werden. Er existiert bereits als Datei.");
            }
            try {
                if (Platform.inProgramDir(this.workdir)) {
                    throw new ApplicationException("Bitte w\u00e4hlen Sie einen Benutzerordner, der sich au\u00dferhalb des Programm-Verzeichnisses befindet.");
                }
            }
            catch (IOException ioe) {
                Logger.error((String)"unable to check canonical path", (Throwable)ioe);
                throw new ApplicationException("Benutzerordner nicht ausw\u00e4hlbar: " + ioe.getMessage());
            }
            if (!this.workdir.exists()) {
                Logger.info((String)("creating " + this.workdir));
                if (!this.workdir.mkdirs()) {
                    throw new Exception("Der Benutzerordner " + this.workdir + " konnte nicht erstellt werden.");
                }
            }
            Logger.info((String)("using workdir: " + this.workdir));
            return this.workdir;
        }
        catch (ApplicationException ae) {
            Logger.warn((String)"resetting \"ask\" flag in .jameica.properties");
            BootstrapSettings.setAskWorkdir(true);
            throw ae;
        }
        catch (Exception e) {
            Logger.warn((String)"resetting \"ask\" flag in .jameica.properties");
            BootstrapSettings.setAskWorkdir(true);
            throw new ApplicationException("Bitte versuchen Sie, Jameica erneut zu starten und w\u00e4hlen Sie einen anderen Benutzerordner.", (Throwable)e);
        }
    }

    public String getDefaultWorkdir() {
        return System.getProperty("user.home") + File.separator + ".jameica";
    }

    public int getOS() {
        if (this.os != -1) {
            return this.os;
        }
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        Logger.debug((String)("os.name: " + os));
        Logger.debug((String)("os.arch: " + arch));
        os = os.toLowerCase();
        arch = arch.toLowerCase();
        if (os.indexOf("linux") != -1) {
            if (arch.indexOf("64") != -1) {
                Logger.debug((String)"linux 64bit");
                this.os = 4;
            } else {
                Logger.debug((String)"linux 32bit");
                this.os = 1;
            }
        } else if (os.indexOf("windows") != -1) {
            if (arch.indexOf("64") != -1) {
                Logger.debug((String)"windows 64bit");
                this.os = 5;
            } else {
                Logger.debug((String)"windows 32bit");
                this.os = 2;
            }
        } else if (os.indexOf("mac") != -1) {
            Logger.debug((String)"macos");
            this.os = 3;
        } else if (os.indexOf("freebsd") != -1) {
            if (arch.indexOf("64") != -1) {
                Logger.debug((String)"freebsd 64bit");
                this.os = 7;
            } else {
                Logger.debug((String)"freebsd 32bit");
                this.os = 6;
            }
        } else {
            Logger.debug((String)"unknown os");
            this.os = 0;
        }
        return this.os;
    }

    public String toRelative(String path) {
        try {
            String f = new File(path).getCanonicalFile().getAbsolutePath();
            String base = new File(Application.getConfig().getWorkDir()).getCanonicalFile().getAbsolutePath();
            if (f.startsWith(base)) {
                String result = f.substring(base.length() + 1).replace("\\", "/");
                Logger.info((String)("to relative: " + path + " -> " + result));
                return result;
            }
            Logger.info((String)("outside workdir: " + path));
            return path;
        }
        catch (Exception e) {
            Logger.error((String)("unable to convert path to relative: " + path), (Throwable)e);
            return path;
        }
    }

    public String toAbsolute(String path) {
        try {
            File f = new File(path);
            if (!f.isAbsolute()) {
                String base = new File(Application.getConfig().getWorkDir()).getCanonicalFile().getAbsolutePath();
                String result = new File(base, path).getCanonicalFile().getAbsolutePath();
                Logger.info((String)("to absolute: " + path + " -> " + result));
                return result;
            }
            Logger.info((String)("already absolute: " + path));
            return path;
        }
        catch (Exception e) {
            Logger.error((String)("unable to convert path to absolute: " + path), (Throwable)e);
            return path;
        }
    }

    public int mapSWTKey(int key) {
        return key;
    }

    public String mapSWTShortcut(String shortcut) {
        return shortcut;
    }
}

